<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToCoursesTable extends Migration
{
    public function up()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->decimal('Weight_lessons', 5, 2)->default(70.00)->after('Status');
            $table->decimal('Weight_quizzes', 5, 2)->default(20.00)->after('Weight_lessons');
            $table->decimal('Weight_assignments', 5, 2)->default(5.00)->after('Weight_quizzes');
            $table->decimal('Weight_practice_tests', 5, 2)->default(5.00)->after('Weight_assignments');
            $table->integer('Total_lessons')->default(0)->after('Weight_practice_tests');
            $table->integer('Total_quizzes')->default(0)->after('Total_lessons');
            $table->integer('Total_assignments')->default(0)->after('Total_quizzes');
            $table->integer('Total_practice_tests')->default(0)->after('Total_assignments');
        });
    }

    public function down()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->dropColumn([
                'Total_practice_tests',
                'Total_assignments',
                'Total_quizzes',
                'Total_lessons',
                'Weight_practice_tests',
                'Weight_assignments',
                'Weight_quizzes',
                'Weight_lessons',
            ]);
        });
    }
}
